package ru.yandex.autotests.directapi.campaigns.geteventslog.validation;

import java.util.Arrays;
import java.util.Collection;

import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.GetEventsLogRequest;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Migrated from old school project (api4l)
 * <br/>
 * Created by chicos on 06.02.14.<br/>
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetEventsValidationLastEventOnlyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = CampaignLogins.SELF_CLIENT;

    private GetEventsLogRequest eventsLogRequest = new GetEventsLogRequest();
    private static final String TIMESTAMP_FROM = "TimestampFrom";
    private static final String LAST_EVENT_ONLY = "LastEventOnly";

    private static String timestampBefore;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Object lastEventOnly;

    @Parameterized.Parameter(1)
    public AxisError expectedAxisError;

    @Parameterized.Parameters(name = "last event only  = {0}, axis error = {1}")
    public static Collection timestampTemplate() {
        Object[][] data = new Object[][]{
                {"\"null\"", new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {"Y", new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {"N", new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {"1", new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {"0", new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {1, new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {0, new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                //https://jira.yandex-team.ru/browse/DIRECT-30977
                {true, new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {false, new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {DateTime.now().getMillis(), new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {DateTime.now().getMillis(), new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {Arrays.asList(), new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {Arrays.asList(DateTime.now().getMillis()), new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)},
                {Arrays.asList(""), new AxisError(25, AxisErrorDetails.LASTEVENTONLY_FIELD)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareEvent() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        timestampBefore = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap finishedEvent = new EventsLogItemMap(api.type())
                .campaignFinishedEvent(campaignId.intValue(), DateTime.now().toDate());
        api.userSteps.eventLogFakeSteps().addEvents(finishedEvent);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5607")
    public void getEventByEmptyFilter() throws ParseException {
        JSONObject eventsLogBean = (JSONObject) (new JSONParser().parse(JsonUtils.toString(eventsLogRequest)));
        eventsLogBean.put(TIMESTAMP_FROM, timestampBefore);
        eventsLogBean.put(LAST_EVENT_ONLY, lastEventOnly);
        api.userSteps.shouldGetErrorOn(Method.GET_EVENTS_LOG, eventsLogBean, expectedAxisError);
    }
}
