package ru.yandex.autotests.directapi.campaigns.geteventslog.validation;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;


/**
 * Migrated from old school project (api4l)
 * <br/>
 * Created by chicos on 06.02.14.<br/>
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetEventsValidationTimestampFromTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = CampaignLogins.SELF_CLIENT;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Object paramValue;

    @Parameterized.Parameter(value = 1)
    public AxisError expectedAxisError;

    @Parameterized.Parameters(name = "timestampFrom = {0}, axis error = {1}")
    public static Collection timestampTemplate() {
        Object[][] data = new Object[][]{
                {null, new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_MUST_NOT_BE_EMPTY)},
                {"null", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_MUST_NOT_BE_EMPTY)},
                {"\"null\"", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"[null]", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"20101010", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010-10-10", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010-10-10 23:59:59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"20101010T23:59:59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"20101010235959", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010-10-10235959", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010-10-10T235959", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010-10-10T23-59-59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2010105T23:59:59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"5-10-2012T23:59:59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"5102012T23:59:59", new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {DateTime.now().getMillis(), new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {Arrays.asList("2014-02-07T10:10:10"), new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {Arrays.asList(), new AxisError(71, AxisErrorDetails.TIMESTAMPFROM_FORMAT_ERROR)},
                {"2014-02-29T10:10:10", new AxisError(36, AxisErrorDetails.EMPTY_STRING)}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5608")
    public void getEventByEmptyFilter() throws ParseException {
        GetEventsLogRequestMap getEventsLogRequestMap = new GetEventsLogRequestMap(api.type());

        JSONObject eventsLogBean = (JSONObject)(new JSONParser().parse(getEventsLogRequestMap.toString()));
        eventsLogBean.put(StringUtils.capitalise(GetEventsLogRequestMap.TIMESTAMP_FROM), paramValue);
        api.userSteps.shouldGetErrorOn(Method.GET_EVENTS_LOG, eventsLogBean, expectedAxisError);
    }
}
