package ru.yandex.autotests.directapi.campaigns.getregions;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RegionInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 9/30/16.
 * https://st.yandex-team.ru/TESTIRT-10304
 */
@Aqua.Test
@Description("проверяем добавление новых стран в Европу")
@Stories(ApiStories.GEO)
@Features(ApiFeatures.NOT_REGRESSION_YET)
@RunWith(Parameterized.class)
public class CheckNewCountryInEuropeTest {
    private static RegionInfo[] regions;
    private int europeId = Integer.valueOf(RegionIDValues.EUROPE_REGION_ID);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.CLIENT_FOR_RUB);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int countryId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {RegionIDValues.ROMANIA_REGION_ID},
                {RegionIDValues.PORTUGAL_REGION_ID}
        });
    }

    @BeforeClass
    public static void setUp() {
        regions = api.userSteps.getRegionsSteps().getRegions();
    }

    @Test
    public void checkCountryInDictionaries() {
        Optional<RegionInfo> countryInfo = Stream.of(regions).filter((p) -> countryId == p.getRegionID()).findFirst();
        assumeThat("Искомая страна найдена в словаре", countryInfo.isPresent(), equalTo(true));
        assertThat("Родительским регионом является Европа", countryInfo.get().getParentID(), equalTo(europeId));
    }


}