package ru.yandex.autotests.directapi.campaigns.getregions;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api45.RegionInfo;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.model.common.RegionTypes;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static ch.lambdaj.Lambda.filter;
import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static org.hamcrest.core.IsEqual.equalTo;

/**
 * Created by chicos on 27.08.14.
 *
 * https://st.yandex-team.ru/DIRECT-33091
 */
@Aqua.Test
@Features(CampaignFeatures.GET_REGIONS)
@Stories(ApiStories.TRANSLOCAL)
@Tag(TagDictionary.TRUNK)
public class GetRegionsTranslocalTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = CampaignLogins.CLIENT_FREE_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5610")
    public void crimeaRegionNoParentTest() {
        RegionInfo[] regions = api.userSteps.getRegionsSteps().getRegions();
        List<RegionInfo> crimeaRegion =
                filter(having(on(RegionInfo.class).getRegionID(), equalTo(Integer.valueOf(RegionIDValues.CRIMEA_REGION_ID))),
                        regions);

        assertThat("Регион Крым отсутствует", crimeaRegion, hasSize(1));
        assertThat("Регион Крым содержит родительский ID", crimeaRegion.get(0).getParentID(), equalTo(0));
        assertThat("Неожиданный тип региона Крым", crimeaRegion.get(0).getRegionType(), equalTo(RegionTypes.ADMINISTRATIVE_AREA));
    }
}
