package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignIDInfo;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignFeatures.GET_STAT_GOALS)
@Tag(TagDictionary.TRUNK)
public class CampaignIDValidateV4LiveTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CampaignLogins.SELF_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5611")
    public void withCharParameters() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                "a",
                new AxisError(501, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5613")
    public void withZeroParameters() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                "0",
                new AxisError(501, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5614")
    public void withNegativeParameters() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                -1,
                new AxisError(501, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5615")
    public void withIntegerParameters() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                1,
                new AxisError(501, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5616")
    public void withArray() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new int[]{1, 0, 2},
                new AxisError(501, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5612")
    public void noRights() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfoMap(new CampaignIDInfo()).withCampaignID(263),
                new AxisError(54, AxisErrorDetails.EMPTY_STRING)
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5617")
    public void nonExisting() {
        Long deletedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.addCompletedAdGroup(deletedCampaignId);
        api.userSteps.campaignSteps().campaignsDelete(deletedCampaignId);

        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfoMap(new CampaignIDInfo()).withCampaignID(deletedCampaignId.intValue()).getBean(),
                new AxisError(1, AxisErrorDetails.EMPTY_STRING)
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5618")
    public void emptyCampaignId() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfo(),
                new AxisError(1, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5619")
    public void zeroCampaignId() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfoMap(new CampaignIDInfo()).withCampaignID(0).getBean(),
                new AxisError(1, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5620")
    public void negativeCampaignId() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfoMap(new CampaignIDInfo()).withCampaignID(-263).getBean(),
                new AxisError(1, AxisErrorDetails.EMPTY_STRING)
        );
    }

}
