package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import org.apache.commons.lang.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.MetrikaGoalsGoalType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.MetrikaGoalsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.converter.BeanToBeanWrapperConverter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.StatGoalInfo;
import ru.yandex.autotests.directapi.common.api45.StatGoalsCampaignIDInfo;
import ru.yandex.autotests.directapi.matchers.beans.EveryItem;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.campaigns.StatGoalInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.convert;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-69356
 */

@Aqua.Test
@Features(CampaignFeatures.GET_STAT_GOALS)
@Issue("https://st.yandex-team.ru/DIRECT-64814")
@Description("В GetStatGoals должны возвращаться цели ecommerce.")
public class GetStatGoalsECommerceTest {
    public static final String ECOMMERCE_LOGIN = CampaignLogins.CLIENT_CAMPAIGNS;
    private static Long ecommerceCampaignId;
    private static Long ecommerceGoalId;
    private static MetrikaGoalsRecord metrikaGoal;
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(ECOMMERCE_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(ECOMMERCE_LOGIN);
        ecommerceGoalId = MetrikaGoals.getRandomEcommerceTypeGoal();
        assumeThat("цель имеет тип ecommerce",
                jooqDbSteps.metrikaGoalsSteps().getMetrikaGoals(ecommerceGoalId).getGoalType(),
                equalTo(MetrikaGoalsGoalType.ecommerce)
        );
        ecommerceCampaignId = api.as(ECOMMERCE_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign();
        jooqDbSteps.campMetrikaGoalsSteps().createCampMetrikaGoals(ecommerceCampaignId, ecommerceGoalId, 200L, 200L);
        metrikaGoal = jooqDbSteps.metrikaGoalsSteps().getMetrikaGoals(ecommerceGoalId);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(ECOMMERCE_LOGIN);
        Long clientId = Long.parseLong(User.get(ECOMMERCE_LOGIN).getClientID());
        dbSteps.featuresSteps().setClientFeature(clientId, "goals_only_with_campaign_counters_used", false);
    }

    @Test
    public void getStatGoalsForCampaignWithECommerce() {
        log.info("Запросим ecommerce-цель для одной кампании: " + ecommerceCampaignId);
        StatGoalsCampaignIDInfo request = new StatGoalsCampaignIDInfo();
        request.setCampaignID(ecommerceCampaignId.intValue());
        StatGoalInfo[] goals = api.as(ECOMMERCE_LOGIN).userSteps.statisticsSteps().getStatGoals(request);

        assumeThat("у кампании есть цели", goals.length, greaterThan(0));
        assertThat(convert(goals, new BeanToBeanWrapperConverter<StatGoalInfo>()).toArray(), EveryItem.everyItem(
                allOf(
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.GOAL_ID), equalTo(ecommerceGoalId)),
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.NAME),
                                equalTo("eCommerce: Purchase (tag № " + metrikaGoal.getName() + ")")),
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.AVAILABLE_FOR_STRATEGY),
                                anyOf(equalTo(Value.NO), equalTo(Value.YES))),
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.AVAILABLE_FOR_CONTEXT_STRATEGY),
                                anyOf(equalTo(Value.NO), equalTo(Value.YES))),
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.GOALS_REACHED), equalTo(200)),
                        hasProperty(StringUtils.uncapitalize(StatGoalInfoMap.CONTEXT_GOALS_REACHED), equalTo(200))
                )
        ));

    }

}
