package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDsInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(CampaignFeatures.GET_STAT_GOALS)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Description("Проверка работы метода с нетекстовыми кампаниями для чужого логина.")
@RunWith(Parameterized.class)
public class GetStatGoalsForNonTextCampaignRightsTest {
    public static String anotherClient = Logins.CLIENT_DOT_LOGIN;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE}});
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns(){
        api.as(CampaignLogins.CLIENT_FREE_YE_DEFAULT);
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(api.userSteps.clientFakeSteps().getUserShard(CampaignLogins.CLIENT_FREE_YE_DEFAULT));
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(nonTextCampaignId, (long) MetrikaGoals.getRandom(), 100L, 100L);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(textCampaignId, (long) MetrikaGoals.getRandom(), 100L, 100L);
    }

    @Before
    public void setType(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5621")
    public void getSummaryStatOfNonTextCampaign(){
        api.as(anotherClient).userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDInfoMap(api.type())
                    .withCampaignID(nonTextCampaignId.intValue()),
                new AxisError(54)

        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5622")
    public void getSummaryStatOfNonTextAndTextCampaign(){
        api.as(anotherClient).userSteps.shouldGetErrorOn(
                Method.GET_STAT_GOALS,
                new CampaignIDsInfoMap(api.type())
                        .withCampaignIDs(nonTextCampaignId.intValue(), textCampaignId.intValue()),
                new AxisError(54));
    }
}
