package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.StatGoalInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(CampaignFeatures.GET_STAT_GOALS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class GetStatGoalsForNonTextCampaignTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;

    @Rule
    public Trashman trasher = new Trashman(api);
    private StatGoalInfo[] statGoalsInfo;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.CPM_DEALS}
        });
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns(){
        api.version(104).as(CampaignLogins.CLIENT_SELF);
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(api.userSteps.clientFakeSteps().getUserShard(CampaignLogins.CLIENT_SELF));
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(nonTextCampaignId, (long) MetrikaGoals.getRandom(), 100L, 100L);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(textCampaignId, (long) MetrikaGoals.getRandom(), 100L, 100L);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CampaignLogins.CLIENT_SELF);
        Long clientId = Long.parseLong(User.get(CampaignLogins.CLIENT_SELF).getClientID());
        dbSteps.featuresSteps().setClientFeature(clientId, "goals_only_with_campaign_counters_used", false);
    }

    @Before
    public void setType(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5623")
    public void getSummaryStatOfNonTextCampaign(){
        statGoalsInfo = api.userSteps.campaignStepsV4().getStatGoals(nonTextCampaignId.intValue());
        assertThat("вызов успешен",statGoalsInfo.length, equalTo(1));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5624")
    public void getSummaryStatOfNonTextAndTextCampaign(){
        statGoalsInfo = api.userSteps.campaignStepsV4().getStatGoals(nonTextCampaignId.intValue(), textCampaignId.intValue());
        assertThat("вызов успешен",statGoalsInfo.length, equalTo(2));
    }
}
