package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignIDSInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 31.01.14
 * Time: 16:10
 * https://jira.yandex-team.ru/browse/TESTIRT-1463
 */
@Aqua.Test
@Features(CampaignFeatures.GET_STAT_GOALS)
@Stories(ApiStories.SHARDING)
public class GetStatGoalsShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

	@ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    public static Long campaignId = 7446965L;
    public static Long campaignIdElse = 7446967L;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.STAT_CLIENT_FOR_SHARDING, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(CampaignLogins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.as(Logins.SUPER_LOGIN).clientLogin(Logins.STAT_CLIENT_FOR_SHARDING).userSteps.campaignSteps().campaignsUnarchive(campaignId, campaignIdElse);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5625")
    public void getStatGoalsPositiveTest() {
        api.as(Logins.SUPER_LOGIN, Logins.SUPER_READER10).userSteps.campaignStepsV4().getStatGoals(campaignId.intValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5626")
    public void getStatGoalsNegativeTest() {
        api.as(Logins.SUPER_LOGIN, CampaignLogins.AGENCY_SHARD_2).userSteps.statisticsSteps()
                .shouldGetErrorOn(Method.GET_STAT_GOALS, new CampaignIDSInfo(new int[]{campaignId.intValue()}, null),
                        new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5627")
    public void getStatGoalsMassTest() {
        api.as(Logins.SUPER_LOGIN, Logins.SUPER_READER10).userSteps.campaignStepsV4()
                .getStatGoals(campaignId.intValue(), campaignIdElse.intValue());
    }
}
