package ru.yandex.autotests.directapi.campaigns.getstatgoals;

import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api4.CampaignIDInfo;
import ru.yandex.autotests.directapi.common.api4.StatGoalInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.campaigns.StatGoalInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.uncapitalize;
import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasProperty;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 12.03.12
 * Time: 12:49
 * Проверка вызова метода
 */
@Aqua.Test
@Features(CampaignFeatures.GET_STAT_GOALS)
public class StatGoalsResponseV4Test {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(4).as(Logins.AGENCY_YE_DEFAULT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;

    @BeforeClass
    public static void initTest() {
        String login = Logins.CLIENT_FREE_YE_DEFAULT;
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        int goalID = MetrikaGoals.getRandom();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(login).campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(
                campaignId, (long)goalID, 200L, 200L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5644")
    public void undefParameters()  {
        api.userSteps.shouldGetErrorOn("",
                Method.GET_STAT_GOALS.toString(),
                null,
                new AxisError(501, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5645")
    public void checkObjectProperties(){
        assertThat("В 4 версии неправильный состав полей класса StatGoalInfo", new StatGoalInfo(),
                allOf(
                        Matchers.not(hasProperty(uncapitalize(StatGoalInfoMap.AVAILABLE_FOR_CONTEXT_STRATEGY))),
                        Matchers.not(hasProperty(uncapitalize(StatGoalInfoMap.CONTEXT_GOALS_REACHED))),
                        Matchers.not(hasProperty(uncapitalize(StatGoalInfoMap.AVAILABLE_FOR_STRATEGY))),
                        Matchers.not(hasProperty(uncapitalize(StatGoalInfoMap.CAMPAIGN_ID))),
                        hasProperty(uncapitalize(StatGoalInfoMap.GOAL_ID)),
                        hasProperty(uncapitalize(StatGoalInfoMap.NAME))
                )
        );
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5643")
    public void getSearchStatGoalsIfExists() {
        StatGoalInfo[] statGoalInfos = api.userSteps.statisticsSteps()
                .getStatGoals(new CampaignIDInfoMap<CampaignIDInfo>(new CampaignIDInfo())
                        .withCampaignID(campaignId.intValue()).getBean());
        assumeThat("у кампании есть цели", statGoalInfos.length, greaterThan(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5646")
    public void noLiveVersionFieldsInGoalsListIfCampaignsRequested() {
        StatGoalInfo[] statGoalInfos = api.userSteps.statisticsSteps()
                .getStatGoals(new CampaignIDInfoMap(new CampaignIDInfo())
                        .withCampaignID(campaignId.intValue()).getBean());
        assertThat(statGoalInfos.length, greaterThan(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5647")
    public void goalsListReturned() {
        StatGoalInfo[] statGoalInfos = api.userSteps.statisticsSteps()
                .getStatGoals(new CampaignIDInfoMap(new CampaignIDInfo())
                        .withCampaignID(campaignId.intValue()).getBean());
        assertThat("Не получены цели", statGoalInfos.length, greaterThan(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5648")
    public void arrayIgnoredGoalsReturned() {
        StatGoalInfo[] statGoalInfos = api.userSteps.statisticsSteps()
                .getStatGoals(new CampaignIDInfoMap(new CampaignIDInfo())
                        .withCampaignID(campaignId.intValue()).getBean());
        assertThat("Не получены цели", statGoalInfos.length, greaterThan(0));
    }
}
