package ru.yandex.autotests.directapi.campaigns.getversion;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45.VersionDesc;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * Created by chicos on 11.03.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1595
 */
@Features(CampaignFeatures.GET_AVAILABLE_VERSION)
@Stories(ApiStories.SHARDING)
@RunWith(Parameterized.class)
public class GetAvailableVersionTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();


    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameters(name = "login = {0}, protocol type = {1}")
    public static Collection roles(){
        Object[][] data = new Object[][]{
                {CampaignLogins.SELF_CLIENT, ProtocolType.SOAP},
                {CampaignLogins.SELF_CLIENT, ProtocolType.JSON},
                {CampaignLogins.SELF_CLIENT_SHARD_2, ProtocolType.SOAP},
                {CampaignLogins.SELF_CLIENT_SHARD_2, ProtocolType.JSON}
        };
        return Arrays.asList(data);
    }

    @Parameterized.Parameter(value = 0)
    public String login;

    @Parameterized.Parameter(value = 1)
    public ProtocolType protocolType;

    @Before
    public void getAvailableVesions() {
        api.as(login).protocol(protocolType);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5649")
    public void getAvailableVersions() {
        VersionDesc[] versionsDesc = api.userSteps.getVersionsSteps().getAvailableVersions();
        List<Integer> versionNums = extract(Arrays.asList(versionsDesc), on(VersionDesc.class).getVersionNumber());
        List<String> links = extract(Arrays.asList(versionsDesc), on(VersionDesc.class).getLinkWSDL());
        assertThat("Некорректные набор версий", versionNums, contains(4));
        assertThat("Некорректные ссылки", links, hasItems(not(isEmptyString())));
    }
}
