package ru.yandex.autotests.directapi.campaigns.production;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationSelectionCriteria;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;

/**
 * Created by chicos on 28.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Stories(CampaignFeatures.MOVE_TO)
public class AdImageProdTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = Logins.CLIENT_SMOKE_PROD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    private static Long campaignId;
    private static Long bannerId1;
    private static Long bannerId2;
    private static AdImage image1;
    private static AdImage image2;

    @BeforeClass
    public static void prepareCampaignImages() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long[] bannerIDs = api.userSteps.addCompletedAdGroupWithTwoAds(campaignId);
        bannerId1 = bannerIDs[0];
        bannerId2 = bannerIDs[1];
        image1 = api.userSteps.imagesSteps().uploadRawImage("Изображение 1", ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR));
        image2 = api.userSteps.imagesSteps().uploadRawImage("Изображение 2", ImagesSteps.getDefaultImageUrl(2, ImageType.REGULAR));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5651")
    public void assignImagesToBannerInGroupTest() {
        api.userSteps.imagesSteps().setAdImageAssociation(bannerId1, image1.getAdImageHash());
        api.userSteps.imagesSteps().setAdImageAssociation(bannerId2, image2.getAdImageHash());
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(new AdImageAssociationSelectionCriteria())
                        .withAdIDS(
                                bannerId1,
                                bannerId2
                        )
        );
        AdImageAssociation[] adImageAssociations = response.getAdImageAssociations();
        assertThat("Не совпадают хэши изображения 1", adImageAssociations[0].getAdImageHash(), equalTo(image1.getAdImageHash()));
        assertThat("Не совпадают хэши изображения 2", adImageAssociations[1].getAdImageHash(), equalTo(image2.getAdImageHash()));
    }

    @AfterClass
    public static void removeCampaign() {
        //remove images
        api.userSteps.imagesSteps().bin.clearBin();
        //delete campaign
        api.userSteps.campaignSteps().campaignsDelete(campaignId);
    }
}
