package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionShortMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author mariabye
 * @author xy6er
 */
@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
public class DeleteSubscriptionTest {
    //DIRECT-36050
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private SubscriptionShortMap subscriptionShortMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class)
            .as(CampaignLogins.CLIENT_SUBSCRIPTION);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void saveSubscription() {
        SubscriptionMap subscriptionMap = new SubscriptionMap(api.type()).defaultSubscription()
                .withSubscriptionResource(SubscriptionMap.TEST_PUSH_TOKEN);
        api.userSteps.subscriptionSteps().saveSubscription(subscriptionMap);
        ConditionFactories.SUBSCRIPTION.until(api.userSteps.subscriptionSteps().subscriptionIs(subscriptionMap));
        subscriptionShortMap = new SubscriptionShortMap(subscriptionMap);

        api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap);
        api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5655")
    public void canDeleteSubscription() {
        log.info("Пользователь " + CampaignLogins.CLIENT_SUBSCRIPTION);
        log.info("Удаляем подписку");
        log.info(JsonUtils.toString(subscriptionShortMap.getBean()));
        assertThat("Неуспешный результат вызова метода " + Method.DELETE_SUBSCRIPTION,
                api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap), equalTo(1));

        ConditionFactories.SUBSCRIPTION.until(
                api.userSteps.subscriptionSteps().subscriptionDeleted(subscriptionShortMap));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5656")
    public void canDeleteNotExistSubscription() {
        log.info("Надо отправить хотя бы одно событие");
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CampaignLogins.CLIENT_SUBSCRIPTION);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.eventLogFakeSteps().addEvents(
                new EventsLogItemMap(api.type()).moneyOutEvent(campaignId.intValue(), timestamp));
        log.info("Удалим подписку");
        api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap);
        ConditionFactories.SUBSCRIPTION.until(
                api.userSteps.subscriptionSteps().subscriptionDeleted(subscriptionShortMap));
        log.info("Удалим второй раз ту же подписку");
        assertThat("Неуспешный результат вызова метода",
                api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap), equalTo(1));
    }

}
