package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionShortMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.directapi.model.subscription.SubscriptionMap.*;

/**
 * @author mariabye
 * @author xy6er
 */
@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
@RunWith(Parameterized.class)
public class DeleteSubscriptionWithInvalidValuesTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).
            as(CampaignLogins.CLIENT_SUBSCRIPTION);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static SubscriptionMap subscriptionMap;

    @Parameterized.Parameter(0)
    public Object subscriptionShort;
    @Parameterized.Parameter(1)
    public AxisError axisError;

    @Parameterized.Parameters()
    public static Collection parameterizedData() {
        String invalidPushTokenSpaces = "b1401fаd 297a91463e93a5c32bba0a43f6fadd11a8ffed14a6e5550271687d4";
        String invalidPushTokenCyrillic = "b14001fаd297a91463e93a5c32bba0a43f6fadd11a8ffed14a6e5550271687d4";
        String invalidSubscriptionType = "apns";

        return Arrays.asList(new Object[][]{
                //invalid SubscriptionResource
                {null, new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_RESOURCE_MUST_NOT_BE_EMPTY)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(SUBSCRIPTION_TYPE_APNS).
                        withSubscriptionResource(null).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_RESOURCE_MUST_NOT_BE_EMPTY)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(SUBSCRIPTION_TYPE_APNS).
                        withSubscriptionResource("").getBean(),
                        new AxisError(71, AxisErrorDetails.INVALID_SUBSCRIPTION_RESOURCE)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(SUBSCRIPTION_TYPE_APNS).
                        withSubscriptionResource(invalidPushTokenSpaces).getBean(),
                        new AxisError(71, AxisErrorDetails.INVALID_SUBSCRIPTION_RESOURCE)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(SUBSCRIPTION_TYPE_APNS).
                        withSubscriptionResource(invalidPushTokenCyrillic).getBean(),
                        new AxisError(71, AxisErrorDetails.INVALID_SUBSCRIPTION_RESOURCE)},

                //invalid SubscriptionType
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(null).
                        withSubscriptionResource(ANNA_HOME_PUSH_TOKEN).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_MUST_NOT_BE_EMPTY)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType("").
                        withSubscriptionResource(ANNA_HOME_PUSH_TOKEN).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_SHOULD_CONTAINS_VALUES)},
                {new SubscriptionShortMap(api.type()).
                        withSubscriptionType(invalidSubscriptionType).
                        withSubscriptionResource(ANNA_HOME_PUSH_TOKEN).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_SHOULD_CONTAINS_VALUES)}
        });
    }

    @BeforeClass
    public static void saveSubscription() {
        subscriptionMap = new SubscriptionMap(api.type()).getSubscriptionFor(ALL_EVENT_TYPES)
                .withSubscriptionResource(ANNA_HOME_PUSH_TOKEN);
        api.userSteps.subscriptionSteps().saveSubscription(subscriptionMap);
        ConditionFactories.SUBSCRIPTION.until(api.userSteps.subscriptionSteps().subscriptionIs(subscriptionMap));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5657")
    public void shouldGetErrorOnDeleteSubscriptionMethodTest() {
        api.userSteps.shouldGetErrorOn(
                Method.DELETE_SUBSCRIPTION,
                subscriptionShort,
                axisError
        );
    }

}
