package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * @author mariabye
 * @author xy6er
 */
@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
@RunWith(Parameterized.class)
public class SaveSubscriptionNotClientRolesNotAllowedTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static SubscriptionMap subscription;

    @Parameterized.Parameter(0)
    public String login;
    @Parameterized.Parameter(1)
    public AxisError axisError;

    @Parameterized.Parameters(name = "Login: {0}")
    public static Collection parameterizedData() {
        return Arrays.asList(new Object[][]{
                {CampaignLogins.AGENCY,
                        new AxisError(54, AxisErrorDetails.METHOD_ALLOWED_CLIENTS_ONLY)},
                {Logins.MANAGER_DEFAULT,
                        new AxisError(54, AxisErrorDetails.METHOD_ALLOWED_CLIENTS_ONLY)}
        });
    }

    @BeforeClass
    public static void initTestData() {
        subscription = new SubscriptionMap(api.type()).getSubscriptionFor(EventType.MONEYIN, EventType.LOWCTR)
                .withSubscriptionResource(SubscriptionMap.TOKEN_FOR_NOT_EXIST_SUBSCRIPTION);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5658")
    public void shouldGetErrorThisMethodAllowedClientsOnlyTest() {
        api.as(login);
        api.userSteps.shouldGetErrorOn(Method.SAVE_SUBSCRIPTION, subscription, axisError);
    }

}
