package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.direct.utils.model.Locale.*;
import static ru.yandex.autotests.directapi.model.geteventslog.EventType.*;

/**
 * User: mariabye
 * @author xy6er
 */

@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
@RunWith(Parameterized.class)
public class SaveSubscriptionTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameter(0)
    public SubscriptionMap actualSubscriptionMap;
    @Parameterized.Parameter(1)
    public SubscriptionMap expectedSubscriptionMap;

    @Parameterized.Parameters()
    public static Collection parameterizedData() {
        SubscriptionMap baseSubscriptionMap =
                new SubscriptionMap(api.type()).getSubscriptionFor(PAUSEDBYDAYBUDGET, MONEYIN)
                        .withSubscriptionResource(SubscriptionMap.IPAD_TOKEN);
        return Arrays.asList(new Object[][]{
                //Timeout
                {baseSubscriptionMap.clone().withTimeout(17), null}, //null means expectedSubscriptionMap == actualSubscriptionMap
                {baseSubscriptionMap.clone().withTimeout(1), null},
                {baseSubscriptionMap.clone().withTimeout(60), null},
                {baseSubscriptionMap.clone().withTimeout(null), baseSubscriptionMap.clone().withTimeout(10)}, //default timeout value 10
                {baseSubscriptionMap.clone().withTimeout(0), null},
                //Locale
                {baseSubscriptionMap.clone().withLocale(RUSSIAN.getName()), null},
                {baseSubscriptionMap.clone().withLocale(ENGLISH.getName()), null},
                {baseSubscriptionMap.clone().withLocale(UKRAINIAN.getName()), null},
                {baseSubscriptionMap.clone().withLocale(null), baseSubscriptionMap.clone().withLocale(RUSSIAN.getName())}, //default locale value RU
                //withEventTypes
                {baseSubscriptionMap.clone().withEventTypes(SubscriptionMap.ALL_EVENT_TYPES), null},
                {baseSubscriptionMap.clone().withEventTypes(MONEYIN, LOWCTR), null},
                {baseSubscriptionMap.clone().withEventTypes(MONEYIN, LOWCTR, MONEYIN),
                        baseSubscriptionMap.clone().withEventTypes(MONEYIN, LOWCTR)}
        });
    }


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class)
            .as(CampaignLogins.CLIENT_SUBSCRIPTION);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5659")
    public void canSaveSubscriptionTest() {
        if (expectedSubscriptionMap == null) { //null means that expectedSubscriptionMap == actualSubscriptionMap
            expectedSubscriptionMap = actualSubscriptionMap;
        }
        TestSteps.assumeThat("Вызов метода " + Method.SAVE_SUBSCRIPTION + "успешен",
                api.userSteps.subscriptionSteps().saveSubscription(actualSubscriptionMap), equalTo(1));
        ConditionFactories.SUBSCRIPTION
                .until(api.userSteps.subscriptionSteps().subscriptionIs(expectedSubscriptionMap));
    }

}
