package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * User: mariabye
 * @author xy6er
 */

@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
@RunWith(Parameterized.class)
public class SaveSubscriptionWithInvalidValuesTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class)
            .as(CampaignLogins.CLIENT_SUBSCRIPTION);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Object subscription;
    @Parameterized.Parameter(1)
    public AxisError axisError;

    @Parameterized.Parameters()
    public static Collection parameterizedData() {
        SubscriptionMap baseSubscriptionMap =
                new SubscriptionMap(api.type()).getSubscriptionFor(EventType.PAUSEDBYDAYBUDGET, EventType.MONEYIN)
                        .withSubscriptionResource(SubscriptionMap.TOKEN_FOR_NOT_EXIST_SUBSCRIPTION);

        String invalidPushToken = "6a12278a 5d082b75 78f9cde9 dde51139 4a875dd0 16e00a17 d0e478a4 f7ae8fe1";
        String invalidSubscriptionType = "apns";
        String invalidLocale = "EN"; //valid value 'en'
        String invalidEventType = "money";

        return Arrays.asList(new Object[][]{
                //invalid SubscriptionResource
                {null, new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_RESOURCE_MUST_NOT_BE_EMPTY)},
                {baseSubscriptionMap.clone().withSubscriptionResource(null).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_RESOURCE_MUST_NOT_BE_EMPTY)},
                {baseSubscriptionMap.clone().withSubscriptionResource("").getBean(),
                        new AxisError(71, AxisErrorDetails.INVALID_SUBSCRIPTION_RESOURCE)},
                {baseSubscriptionMap.clone().withSubscriptionResource(invalidPushToken).getBean(),
                        new AxisError(71, AxisErrorDetails.INVALID_SUBSCRIPTION_RESOURCE)},

                //invalid SubscriptionType
                {baseSubscriptionMap.clone().withSubscriptionType(null).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_MUST_NOT_BE_EMPTY)},
                {baseSubscriptionMap.clone().withSubscriptionType("").getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_SHOULD_CONTAINS_VALUES)},
                {baseSubscriptionMap.clone().withSubscriptionType(invalidSubscriptionType).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_SUBSCRIPTION_TYPE_SHOULD_CONTAINS_VALUES)},

                //Timeout
                {baseSubscriptionMap.clone().withTimeout(-10).getBean(),
                        new AxisError(71, AxisErrorDetails.THE_TIMEOUT_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE)},
                {baseSubscriptionMap.clone().withTimeout(61).getBean(),
                        new AxisError(71, AxisErrorDetails.THE_TIMEOUT_FIELD_MUST_BE_GREATER_THAN_60)},

                //Locale
                {baseSubscriptionMap.clone().withLocale("").getBean(),
                        new AxisError(511, AxisErrorDetails.UNKNOWN_LANGUAGE, "")},
                {baseSubscriptionMap.clone().withLocale(invalidLocale).getBean(),
                        new AxisError(511, AxisErrorDetails.UNKNOWN_LANGUAGE, invalidLocale)},

                //withEventTypes
                {baseSubscriptionMap.clone().withEventTypes(null).getBean(),
                        new AxisError(9, AxisErrorDetails.EVENT_TYPES_MUSTBE_ARRAY)},
                {baseSubscriptionMap.clone().withEventTypes(null, EventType.MONEYIN).getBean(),
                        new AxisError(71, AxisErrorDetails.EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES)},
                {baseSubscriptionMap.clone().withEventTypes().getBean(), //same new String[0]
                        new AxisError(30, AxisErrorDetails.EVENT_TYPES_ARRAY_COULDNT_BE_EMPTY)},
                {baseSubscriptionMap.clone().withEventTypes(invalidEventType).getBean(),
                        new AxisError(71, AxisErrorDetails.EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES)},
                {baseSubscriptionMap.clone().withEventTypes(EventType.MONEYIN, invalidEventType).getBean(),
                        new AxisError(71, AxisErrorDetails.EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES)},
                {baseSubscriptionMap.clone().withEventTypes(null, EventType.MONEYIN).getBean(),
                        new AxisError(71, AxisErrorDetails.EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES)},
                {baseSubscriptionMap.clone().withEventTypes(EventType.MONEYIN, "").getBean(),
                        new AxisError(71, AxisErrorDetails.EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES)}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5660")
    public void shouldGetErrorOnSaveSubscriptionMethodTest() {
        api.userSteps.shouldGetErrorOn(Method.SAVE_SUBSCRIPTION, subscription, axisError);
    }

}
