package ru.yandex.autotests.directapi.campaigns.push;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionShortMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author xy6er
 */
@Aqua.Test
@Features(CampaignFeatures.SUBSCRIPTION)
public class ShardSubscriptionTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class)
            .as(CampaignLogins.CLIENT_SUBSCRIPTION_SHARD_2);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void reshardUser(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(CampaignLogins.CLIENT_SUBSCRIPTION_SHARD_2, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5661")
    public void deleteSubscriptionWithShardClient() {
        SubscriptionMap subscriptionMap = new SubscriptionMap(api.type()).defaultSubscription().
                withSubscriptionResource(SubscriptionMap.SHARD_TOKEN);
        assertThat("Неуспешный результат вызова метода " + Method.SAVE_SUBSCRIPTION,
                api.userSteps.subscriptionSteps().saveSubscription(subscriptionMap), equalTo(1));
        ConditionFactories.SUBSCRIPTION.until(api.userSteps.subscriptionSteps().subscriptionIs(subscriptionMap));
        SubscriptionShortMap subscriptionShortMap = new SubscriptionShortMap(subscriptionMap);
        assertThat("Неуспешный результат вызова метода " + Method.DELETE_SUBSCRIPTION,
                api.userSteps.subscriptionSteps().deleteSubscription(subscriptionShortMap), equalTo(1));
        ConditionFactories.SUBSCRIPTION.until(
                api.userSteps.subscriptionSteps().subscriptionDeleted(subscriptionShortMap));
    }

}
