package ru.yandex.autotests.directapi.campaigns.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.Matchers.lessThan;
import static org.junit.Assert.assertThat;

/**
 * Author pavryabov
 * Date 09.04.14
 */
@Aqua.Test
@Features(CampaignFeatures.TIME_MONITOR)
@Stories(CampaignFeatures.CREATE_OR_UPDATE_CAMPAIGN)
public class CreateCampaignTimeSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5675")
    public void createCampaignTimeTest() {
        long start = System.currentTimeMillis();
        api.userSteps.campaignSteps().addDefaultTextCampaigns(10);
        long time = System.currentTimeMillis() - start;
        assertThat("API работает очень долго. Создание 10 кампаний длится более 45 секунд", time, lessThan(45000l));
    }
}
