package ru.yandex.autotests.directapi.clients;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.isIn;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11.06.15.
 */
@Aqua.Test
@Features(ClientFeatures.RESHARD_ALL_USERS)
@Issue("TESTIRT-5883")
@Description("Сценарий для переноса всех клиентов из MongoDB в ожидаемые шарды")
@RunWith(Parameterized.class)
public class ReshardAllUsersToExpectedShards {

    private static final Collection<Integer> ALLOWABLE_SHARDS = Arrays.asList(5, 6);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameterized.Parameter(0)
    public User user;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> users() {
        return User.getAll().stream()
                .sorted((x, y) -> x.getLogin().compareTo(y.getLogin()))
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5689")
    public void reshardUserToExpectedShard() {
        int expectedShard = user.getExpectedShard();
        String login = user.getLogin();
        assumeThat("ожидаемый шард пользователя является допустимым", expectedShard, isIn(ALLOWABLE_SHARDS));
        api.userSteps.clientSteps().reshardUserToExpectedShard(login);
    }
}
