package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.Rule;

import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: rockman
 * Date: 12.11.13
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
public class CreateNewSubClientBalanceIntegrationTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String agencyLogin = ClientLogins.AGENCY_INVOICE_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String CLIENT_BASE = "test";
    private Account account;

    @Before
    public void createSubClient() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        CreateNewSubclientResponse client = api.userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, agencyLogin, Currency.RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        api.userSteps.campaignStepsV5().addDefaultTextCampaign(clientInfo.getLogin());
        api.userSteps.financeSteps().enableSharedAccount(clientInfo.getLogin());
        account = api.userSteps.financeSteps().getAccount(clientInfo.getLogin());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5690")
    public void requestToBalance() {
        api.as(agencyLogin);

        float minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue();
        String requestID = api.userSteps.financeSteps()
                .getInvoiceRequestID(account.getAccountID(), minInvoiceAmount, Currency.RUB);
        api.userSteps.balanceSteps().operator(User.get(agencyLogin))
                .requestAmountShouldBe(requestID, equalTo(minInvoiceAmount));
    }
}
