package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/19/15.
 * https://st.yandex-team.ru/TESTIRT-4386
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
@Issue("https://st.yandex-team.ru/DIRECT-36552")
@Description("Указание существующего логина в методе CreateNewSubclient")
public class CreateNewSubClientExistentLoginTest {

    private static final String AGENCY_LOGIN = ClientLogins.AGENCY_INVOICE_2;
    private static final String MANAGER_LOGIN = ClientLogins.MANAGER_GEO;
    private static final String EXISTENT_LOGIN = ClientLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @Title("Вызов метода от имени агенства")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5691")
    public void createNewClientWithAgencyLogin() {
        api.as(AGENCY_LOGIN).userSteps.shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .defaultSubclient("", AGENCY_LOGIN)
                        .withCurrency(Currency.RUB)
                        .withLogin(EXISTENT_LOGIN),
                new AxisError(252));
    }

    @Test
    @Title("Вызов метода от имени гео-менеджера")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5692")
    public void createNewClientWithManagerLogin() {
        api.as(MANAGER_LOGIN).wsdl(APIPort_PortType.class).userSteps.shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withServicedClient(Value.YES)
                        .withCurrency(Currency.RUB)
                        .withLogin(EXISTENT_LOGIN),
                new AxisError(252));
    }
}
