package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientRequest;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
@RunWith(Parameterized.class)
public class CreateNewSubClientShardingNegativeTest {
    protected Logger log = LogManager.getLogger(this.getClass());
    private static final String CLIENT_BASE = "test";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameters(name = "Operator = {0}")
    public static Collection roles() {
        Object[] data = new Object[][]{
                {Logins.SERVICED_CLIENT_IN_2_SHARD},
                {Logins.CLIENT_IN_2_SHARD},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SERVICED_CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initClient(){
        api.as(Logins.SUPER_LOGIN,operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5693")
    public void tryCreateClientShouldBeError(){
        CreateNewSubclientRequest param = new CreateNewSubclientRequest();
        param.setAgencyLogin(operator);
        param.setSurname(CLIENT_BASE+RandomStringUtils.randomAlphabetic(3));
        param.setLogin(CLIENT_BASE+RandomStringUtils.randomAlphabetic(3));
        param.setName(CLIENT_BASE);
        param.setCurrency(Currency.RUB.toString());
        api.userSteps.shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                param,
                new AxisError(54, AxisErrorDetails.NO_PERMISSION_TO_CREATE_CLIENTS));
    }
}
