package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
public class CreateNewSubClientShardingPositiveTest {
    protected Logger log = LogManager.getLogger(this.getClass());
    private static final String agencyLogin = Logins.AGENCY_IN_2_SHARD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin).version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest(){
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyLogin, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5694")
    public void successCreateClientInAnotherShardTest(){
        String clientBase = "test";
        CreateNewSubclientResponse newSubClient =
                api.userSteps.clientSteps()
                        .createNewAgencySubClient(clientBase, agencyLogin, Currency.RUB);
        assertThat("Не создался суб-клиент", newSubClient, not(equalTo(new CreateNewSubclientResponse())));
    }
}
