package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * User: rockman
 * Date: 29.10.13
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
@Stories(ApiStories.CURRENCY)
public class CreateNewSubClientTest {
    //DIRECT-56447

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String CLIENT_BASE = "test";
    private static final String AGENCY_RUB_LOGIN = ClientLogins.AGENCY_INVOICE_2;
    private static final String AGENCY_YF_LOGIN = ClientLogins.AGENCY_TRANSFER_1;
    private static final String AGENCY_EUR_LOGIN = Logins.AGENCY_EUR;
    private static final String AGENCY_BYN_LOGIN = Logins.BYN_AGENCY1;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_EUR_LOGIN);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_YF_LOGIN);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_RUB_LOGIN);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_BYN_LOGIN);
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcFetchAgencyCountryCurrency(AGENCY_YF_LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5695")
    public void createUnusedfCurrencySubClientNewRUBAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_RUB_LOGIN).userSteps.clientSteps()
                .createNewSubClient(new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_RUB_LOGIN)
                        .withCurrency("cu"));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    //https://jira.yandex-team.ru/browse/DIRECT-28444
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5698")
    public void createNullCurrencySubClientNewRUBAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_RUB_LOGIN).userSteps.clientSteps()
                .createNewSubClient(new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_RUB_LOGIN)
                        .withCurrency((String) null));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5696")
    public void createRUBSubClientNewRUBAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_RUB_LOGIN).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, AGENCY_RUB_LOGIN, Currency.RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5697")
    public void createWrongCurrencySubClientNewRUBAgency() {
        api.as(AGENCY_RUB_LOGIN).userSteps.clientSteps().shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_RUB_LOGIN)
                        .withCurrency(Currency.CHF),
                new AxisError(71,
                        AxisErrorDetails.FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN, Currency.RUB.toString()));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5699")
    public void createUnusedCurrencySubClientOldRussianAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_YF_LOGIN).userSteps.clientSteps().createNewSubClient(
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_YF_LOGIN)
                        .withCurrency("cu"));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5700")
    public void createNullCurrencySubClientOldRussianAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_YF_LOGIN).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, AGENCY_YF_LOGIN);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5701")
    public void createRUBSubClientOldRussianAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_YF_LOGIN).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, AGENCY_YF_LOGIN, Currency.RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5702")
    public void createUAHSubClientOldRussianAgency() {
        api.as(AGENCY_YF_LOGIN).userSteps.clientSteps().shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_YF_LOGIN)
                        .withCurrency(Currency.UAH),
                new AxisError(71,
                        AxisErrorDetails.FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN, Currency.RUB));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5703")
    public void createNullCurrencySubClientNewEURAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_EUR_LOGIN).userSteps.clientSteps()
                .createNewSubClient(new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_EUR_LOGIN)
                        .withCurrency((String) null));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.EUR.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5704")
    public void createEURSubClientNewEURAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_EUR_LOGIN).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, AGENCY_EUR_LOGIN, Currency.EUR);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.EUR.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5705")
    public void createCHFSubClientNewEURAgency() {
        api.as(AGENCY_EUR_LOGIN).userSteps.clientSteps().shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_EUR_LOGIN)
                        .withCurrency(Currency.CHF),
                new AxisError(71,
                        AxisErrorDetails.FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN, Currency.EUR));
    }

    @Test
    public void createNullCurrencySubClientNewBYNAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_BYN_LOGIN).userSteps.clientSteps().createNewSubClient(
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_BYN_LOGIN)
                        .withCurrency((String) null));
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента",
                clientInfo.getClientCurrencies(), beanDiffer(new String[]{Currency.BYN.toString()}));
    }

    @Test
    public void createBYNSubClientNewBYNAgency() {
        CreateNewSubclientResponse client = api.as(AGENCY_BYN_LOGIN).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, AGENCY_BYN_LOGIN, Currency.BYN);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("Неверная валюта клиента", clientInfo.getClientCurrencies()[0], equalTo(Currency.BYN.toString()));
    }

    @Test
    public void createRUBSubClientNewBYNAgency() {
        api.as(AGENCY_BYN_LOGIN).userSteps.clientSteps().shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withRandomLogin(CLIENT_BASE)
                        .withAgencyLogin(AGENCY_BYN_LOGIN)
                        .withCurrency(Currency.RUB),
                new AxisError(71,
                        AxisErrorDetails.FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN, Currency.BYN));
    }
}
