package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static org.hamcrest.Matchers.*;

/**
 * Created by lightelfik on 20.09.16.
 * https://st.yandex-team.ru/TESTIRT-10181
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Cоздание клиента, который уже есть в Балансе без явного указания валюты")
@Issue("https://st.yandex-team.ru/DIRECT-57679")
public class CreateNewSubclientExistInBalancePositiveTest {

    private static final String LOGIN = "at-login-no-direct2";
    private static final String UID = "421234120";
    private static final Integer CLIENT_ID = 17575744;

    private static final String LOGIN_WITHOUT_REGION = "at-login-no-direct8";
    private static final String UID_WITHOUT_REGION = "421827469";
    private static final Integer CLIENT_WITHOUT_REGION = 17594667;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void prepareClient() {
        api.userSteps.balanceSteps().createClientId(CLIENT_ID, Currency.RUB, RegionIDValues.RUSSIA.getId());
        api.userSteps.balanceSteps().associateClientIdToLogin(CLIENT_ID, UID);
        api.userSteps.balanceSteps().createClientId(CLIENT_WITHOUT_REGION, Currency.YND_FIXED, null);
        api.userSteps.balanceSteps().associateClientIdToLogin(CLIENT_WITHOUT_REGION, UID_WITHOUT_REGION);
    }

    @Test
    public void createClientIfItExistInBalanceWithOneCurrency() {
        CreateNewSubclientResponse client = api.as(Logins.MANAGER_GEO).userSteps.clientSteps()
                .createNewSubClient(
                        new CreateNewSubclientRequestMap(api.type())
                            .withLogin(LOGIN)
                            .withServicedClient(Value.YES)
                            .withLoginExists(true)
                );
        assertThat("Клиент создан с неправильной валютой",
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                is(array(equalTo(Currency.RUB.toString())))
        );
    }

    @Test
    public void createClientIfItExistInBalanceWithoutRegion() {
        CreateNewSubclientResponse client = api.as(Logins.MANAGER_GEO).userSteps.clientSteps()
                .createNewSubClient(
                        new CreateNewSubclientRequestMap(api.type())
                                .withLogin(LOGIN_WITHOUT_REGION)
                                .withServicedClient(Value.YES)
                                .withLoginExists(true)
                );
        assertThat("Клиент создан с неправильной валютой",
                ((ClientInfo) api.as(Logins.SUPER_LOGIN).userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                nullValue()
        );
    }

}
