package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by pavryabov on 26.05.16.
 * https://st.yandex-team.ru/TESTIRT-9311
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
@Description("Попытка создать невалютного клиента, который уже есть в Балансе и у которого там есть валюта")
@Issue("https://st.yandex-team.ru/DIRECT-47484")
public class CreateNewSubclientExistInBalanceTest {

    private static final String LOGIN_WITH_CURRENCY = "at-login-no-direct1";
    private static final Integer CLIENT_ID_WITH_CURRENCY = 12565257;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void prepareClient() {
        ClientFakeInfo clientInfo = api.userSteps.clientFakeSteps().getClientData(LOGIN_WITH_CURRENCY);
        assumeThat("получена информация по клиенту", clientInfo.getPassportID(), notNullValue());
        String uid = clientInfo.getPassportID();
        api.userSteps.balanceSteps().createClientId(CLIENT_ID_WITH_CURRENCY, Currency.RUB, RegionIDValues.RUSSIA.getId());
        api.userSteps.balanceSteps().associateClientIdToLogin(CLIENT_ID_WITH_CURRENCY, uid);

    }

    @Test
    public void createClientIfItExistInBalanceInRub() {
        //Если тест упадет из-за того, что метод создал клиента, то его надо будет или удалять руками, или менять на другого
        //Тест рассчитывает, что в Директе данного клиента еще нет
        api.as(Logins.MANAGER_GEO).userSteps.shouldGetErrorOn(
                Method.CREATE_NEW_SUBCLIENT,
                new CreateNewSubclientRequestMap(api.type())
                        .withLogin(LOGIN_WITH_CURRENCY)
                        .withServicedClient(Value.YES)
                        .withLoginExists(true)
                        .withCurrency(Currency.YND_FIXED).getBean(),
                new AxisError(254, AxisErrorDetails.CLIENT_IS_ALREADY_USES_OTHER_CURRENCY));
    }
}