package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.commons.lang.StringUtils;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;

/**
 * User: rockman
 * Date: 11.11.13
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
public class CreateNewSubclientManagerTest {

    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String CLIENT_BASE = "test";
    private static final String GEO_MANAGER = "at-direct-transfer-mngr";
    private static final String GEO_AGENCY = "transfer-mngr-agency";

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5707")
    public void expectErrorCreateServicedClientNotGeoManager() {
        api.as(ClientLogins.MANAGER_DEFAULT).userSteps.clientSteps()
                .shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                        new CreateNewSubclientRequestMap(api.type())
                                .defaultSubclient(CLIENT_BASE, null)
                                .withServicedClient(Value.YES).getBean(),
                        new AxisError(54, AxisErrorDetails.YOU_HAVE_NO_RIGHTS_FOR_THIS_OPERATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5708")
    public void expectErrorCreateAgencyClientNotGeoManager() {
        api.as(ClientLogins.MANAGER_DEFAULT).userSteps.clientSteps()
                .shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                        new CreateNewSubclientRequestMap(api.type())
                                .defaultSubclient(CLIENT_BASE, ClientLogins.AGENCY_YE_DEFAULT).getBean(),
                        new AxisError(54, AxisErrorDetails.YOU_HAVE_NO_RIGHTS_FOR_THIS_OPERATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5709")
    public void createServicedClientNoCurrencyGeoManager() {
        CreateNewSubclientResponse client = api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .createServicedClient(CLIENT_BASE, GEO_MANAGER);
        assertThat("Клиент создан с неправильной валютой",
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5706")
    public void expectErrorCreateServicedClientCuCurrencyGeoManager() {
        api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                        new CreateNewSubclientRequestMap(api.type())
                                .defaultServicedSubclient(CLIENT_BASE)
                                .withCurrency("cu")
                                .getBean(),
                        new AxisError(254, AxisErrorDetails.INVALID_CURRENCY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5710")
    public void createServicedClientRubCurrencyGeoManager() {
        CreateNewSubclientResponse client = api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .createNewServicedSubClient(CLIENT_BASE, GEO_MANAGER, Currency.RUB);
        assertThat("Клиент создан с правильной валютой",
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                equalTo(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5711")
    public void expectErrorCreateAgencyClientWithoutAgencyLogin() {
        api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                        new CreateNewSubclientRequestMap(api.type())
                                .defaultSubclient(CLIENT_BASE, null).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                                StringUtils.capitalise(ClientInfoMap.AGENCY_LOGIN)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5712")
    public void expectErrorCreateAgencyClientAnotherCurrencyGeoManager() {
        api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                        new CreateNewSubclientRequestMap(api.type())
                                .defaultSubclient(CLIENT_BASE, GEO_AGENCY)
                                .withCurrency(Currency.USD).getBean(),
                        new AxisError(71, AxisErrorDetails.FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN,
                                Currency.RUB.toString()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5713")
    public void createAgencyClientRubCurrencyGeoManager() {
        CreateNewSubclientResponse client = api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, GEO_AGENCY, Currency.RUB);
        assertThat("Клиент создан с неправильной валютой",
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                equalTo(new String[]{Currency.RUB.toString()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5714")
    public void createAgencyClientWithoutCurrencyGeoManager() {
        CreateNewSubclientResponse client = api.as(ClientLogins.SUPER_LOGIN, GEO_MANAGER).userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, GEO_AGENCY);
        assertThat("Клиент создан с неправильной валютой",
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client.getLogin())).getClientCurrencies(),
                equalTo(new String[]{Currency.RUB.toString()}));
    }
}
