package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.junit.Rule;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: rockman
 * Date: 11.11.13
 */
@Aqua.Test
@Features(ClientFeatures.CREATE_CLIENT)
@Stories(ApiStories.SHARED_ACCOUNT)
public class CreateSubClientIntegrationTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agencyLogin = ClientLogins.AGENCY_INVOICE_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String CLIENT_BASE = "test";
    private ClientInfo clientInfo;

    @Before
    public void createSubClient() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        CreateNewSubclientResponse client = api.userSteps.clientSteps()
                .createNewAgencySubClient(CLIENT_BASE, agencyLogin, Currency.RUB);
        clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5716")
    public void createSubClientWithCampaignEnableSharedAccount() {
        api.userSteps.campaignStepsV5().addDefaultTextCampaign(clientInfo.getLogin());

        api.userSteps.financeSteps().enableSharedAccount(clientInfo.getLogin());
        Account account = api.userSteps.financeSteps().getAccount(clientInfo.getLogin());
        assertThat(account.getCurrency(), equalTo(Currency.RUB.toString()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5717")
    public void createSubClientWithoutCampaignEnableSharedAccount() {
        api.userSteps.campaignStepsV5().addDefaultTextCampaign(clientInfo.getLogin());
        Account account = api.userSteps.financeSteps().getAccount(clientInfo.getLogin());
        assertThat(account.getCurrency(), equalTo(Currency.RUB.toString()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5718")
    public void shouldGetErrorOnGetWithoutCampaign() {
        AccountManagementResponse response = api.userSteps.financeSteps()
                .get(new String[]{clientInfo.getLogin()}, null);
        api.userSteps.financeSteps().shouldGetErrorsOnAccountManagementGet(
                clientInfo.getLogin(), new AxisError(515, AxisErrorDetails.EMPTY_STRING));
    }
}
