package ru.yandex.autotests.directapi.clients.createnewsubclient;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientRequest;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 13.01.14.
 * для логина выставляем лимит вызова CreateNewSubClient = 1
 * убедившись что логин находится в 1 шарде
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Stories(ApiStories.SHARDING)
public class ShardingLimitTest {
    protected Logger log = LogManager.getLogger(this.getClass());
    public final String clientBase = "test";
    public static final String agencyLogin = Logins.AGENCY_IN_2_SHARD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void initClient(){
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyLogin, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AT_SUB_LIMIT2, ShardNumbers.EXTRA_SHARD);
        api.as(Logins.SUPER_LOGIN, agencyLogin);
        api.userSteps.clientSteps().createNewAgencySubClient(clientBase, agencyLogin, Currency.RUB);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5720")
    public void test(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyLogin, ShardNumbers.EXTRA_SHARD);
        CreateNewSubclientRequest param = new CreateNewSubclientRequest();
        param.setAgencyLogin(agencyLogin);
        param.setSurname(clientBase+RandomStringUtils.randomAlphabetic(3));
        param.setLogin(clientBase+RandomStringUtils.randomAlphabetic(3));
        param.setName(Logins.AT_SUB_LIMIT2);
        param.setCurrency(Currency.RUB.toString());
        api.userSteps.shouldGetErrorOn(Method.CREATE_NEW_SUBCLIENT,
                param,
                new AxisError(56));
    }
}
