package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.ClientRight;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.AllOf.allOf;

/**
 * User: mariabye
 * Date: 27.02.13
 */

@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Stories(ApiStories.CLIENT_RIGHTS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ClientRightsResponseAgencyLoginTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        Object[][] roleValues = new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPPORT},
                {Logins.SUPER_READER},
                {Logins.MEDIA},
                {Logins.MANAGER_DEFAULT}
        };
        return Arrays.asList(roleValues);
    }

    @Parameterized.Parameter
    public String login;
    private static ClientInfo agency;
    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;
    private static String subClientLogin;

    @BeforeClass
    public static void initTest() {
        agency = api.as(Logins.SUPER_LOGIN).userSteps.clientSteps().getClientInfo(agencyLogin);
        ClientInfo[] subclient = api.as(agencyLogin).userSteps.clientSteps().getClientsList();
        subClientLogin = subclient[0].getLogin();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5758")
    public void agencyShouldSeeAgencyNameAndLogin() {
        ClientInfo client = api.as(login)
                .userSteps.clientSteps().getClientInfo(subClientLogin);

        List<ClientRight> rights = filter(
                allOf(
                        having(on(ClientRight.class).getAgencyName(), equalTo(agency.getAgencyName())),
                        having(on(ClientRight.class).getAgencyLogin(), equalTo(agencyLogin)))
                ,client.getClientRights());
        assertThat("Неверный данные об агентстве в списке прав. " + JsonUtils.toString(client.getClientRights()),
                rights, hasSize(3));
    }
}
