package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.ClientRight;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.AllOf.allOf;

/**
 * User: mariabye
 * Date: 27.02.13
 */

@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Stories(ApiStories.CLIENT_RIGHTS)
@Tag(TagDictionary.TRUNK)
public class ClientRightsResponseTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ClientInfo agency;
    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;
    private static String subClientLogin;

    @BeforeClass
    public static void initTest() {
        agency = api.as(Logins.SUPER_LOGIN).userSteps.clientSteps().getClientInfo(agencyLogin);
        ClientInfo[] subclient = api.as(agencyLogin).userSteps.clientSteps().getClientsList();
        subClientLogin = subclient[1].getLogin();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5762")
    public void newClientShouldSeeAgencyName() {
        CreateNewSubclientResponse subClient =
                api.as(agencyLogin).userSteps.clientSteps().createNewAgencySubClient("at-d-ag", agencyLogin, Currency.RUB);
        api.userSteps.clientFakeSteps().enableAPI(subClient.getLogin());
        ClientInfo client = api.as(Logins.SUPER_LOGIN, subClient.getLogin())
                .userSteps.clientSteps().getClientInfo(subClient.getLogin());

        List<ClientRight> rights = filter(
                allOf(
                    having(on(ClientRight.class).getAgencyName(), equalTo(agency.getAgencyName())),
                    having(on(ClientRight.class).getAgencyLogin(), nullValue()))
                ,client.getClientRights());
        assertThat("Неверные данные об агентстве в списке прав. " + JsonUtils.toString(client.getClientRights()),
                rights, hasSize(3));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5759")
    public void oldClientShouldSeeAgencyName() {
        api.userSteps.clientFakeSteps().enableAPI(subClientLogin);
        ClientInfo client = api.as(Logins.SUPER_LOGIN, subClientLogin)
                .userSteps.clientSteps().getClientInfo(subClientLogin);

        List<ClientRight> rights = filter(
                allOf(
                        having(on(ClientRight.class).getAgencyName(), equalTo(agency.getAgencyName())),
                        having(on(ClientRight.class).getAgencyLogin(), nullValue()))
                ,client.getClientRights());
        assertThat("Неверные данные об агентстве в списке прав. " + JsonUtils.toString(client.getClientRights()),
                rights, hasSize(3));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5760")
    public void agencyShouldNotSeeAgencyNameAndLogin() {
        api.userSteps.clientFakeSteps().enableAPI(subClientLogin);
        ClientInfo client = api.as(Logins.SUPER_LOGIN, subClientLogin)
                .userSteps.clientSteps().getClientInfo(subClientLogin);

        List<ClientRight> rights = filter(
                allOf(
                        having(on(ClientRight.class).getAgencyName(), equalTo(agency.getAgencyName())),
                        having(on(ClientRight.class).getAgencyLogin(), nullValue()))
                ,client.getClientRights());
        assertThat("Неверные данные об агентстве в списке прав. " + JsonUtils.toString(client.getClientRights()),
                rights, hasSize(3));
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5761")
    public void placerShouldNotSeeClientRights() {
        ClientInfo client = api.as(Logins.SUPER_LOGIN, Logins.PLACER)
                .userSteps.clientSteps().getClientInfo(subClientLogin);

        assertThat("Неверный данные об агентстве в списке прав. " + JsonUtils.toString(client.getClientRights()),
                client.getClientRights(), Matchers.nullValue());
    }
}
