package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;


/**
 * User: rockman
 * Date: 07.10.13
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class GetClientInfoAgencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String agencyLogin;

    @Parameterized.Parameter(value = 1)
    public String[] currency;

    @Parameterized.Parameters(name = "Agency = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_YE_DEFAULT, new String[]{Currency.RUB.toString()}},
                {Logins.AGENCY_RUB, new String[]{Currency.RUB.toString()}},
                {Logins.AGENCY_UAH, new String[]{Currency.UAH.toString()}},
                {Logins.AGENCY_EUR, new String[]{Currency.EUR.toString()}},
                {Logins.AGENCY_USD, new String[]{Currency.USD.toString()}},
                {Logins.AGENCY_KZT, new String[]{Currency.KZT.toString()}},
                {Logins.AGENCY_CHF, new String[]{Currency.CHF.toString()}},
                {Logins.AGENCY_TRY, new String[]{Currency.TRY.toString()}},
                {Logins.AGENCY_BYN, new String[]{Currency.BYN.toString()}},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void getAgencyCurrencies() {
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcFetchAgencyCountryCurrency(Logins.AGENCY_YE_DEFAULT);
    }

    //https://jira.yandex-team.ru/browse/DIRECT-28445
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5763")
    public void getClientInfoForCurrencyAgency() {
        ClientInfo clientInfo =
                (ClientInfo) api.as(agencyLogin).userSteps.clientSteps()
                        .getClientInfo(agencyLogin);
        assertThat("Неправильное значение ClientCurrencies",
                clientInfo.getClientCurrencies(), equalTo(currency));
    }
}
