package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * Author pavryabov
 * Date 20.06.14
 * https://jira.yandex-team.ru/browse/TESTIRT-364
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetClientInfoCurrencyTest {
    //DIRECT-56856
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public Currency currency;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_RUB, Currency.RUB},
                {Logins.LOGIN_FOR_USD, Currency.USD},
                {Logins.LOGIN_FOR_UAH, Currency.UAH},
                {Logins.LOGIN_FOR_EUR, Currency.EUR},
                {Logins.LOGIN_FOR_KZT, Currency.KZT},
                {Logins.LOGIN_FOR_CHF, Currency.CHF},
                {Logins.LOGIN_FOR_TRY, Currency.TRY},
                {Logins.CLIENT_BYN_VAT_TEST, Currency.BYN}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5764")
    public void getClientInfo() {
        ClientInfo clientInfo = api.as(login).userSteps.clientSteps().getClientInfo(login);
        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher((ClientInfoMap.CURRENCY), nullValue());
        strategy.putFieldMatcher((ClientInfoMap.CLIENT_CURRENCIES), equalTo(new String[]{currency.toString()}));
        assertThat(clientInfo,
                beanEquals(new ClientInfoMap(api.type())
                        .withVATRate((float) MoneyCurrency.get(currency).getVatRate() * 100).getBean())
                        .accordingStrategy(strategy));
    }
}
