package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@RunWith(Parameterized.class)
public class GetClientInfoShardingPositiveTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String[] client;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.CLIENT_IN_2_SHARD,new String[]{Logins.CLIENT_IN_2_SHARD}},
                {Logins.SERVICED_CLIENT_IN_2_SHARD,new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}},
                {Logins.AGENCY_IN_2_SHARD, new String[]{Logins.SUB_IN_2_SHARD}},
                {Logins.AGENCY_IN_2_SHARD, new String[]{Logins.SUB_IN_1_SHARD}},
                {Logins.AGENCY_YE_DEFAULT, new String[]{Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.MANAGER_DEFAULT, new String[]{Logins.AGENCY_IN_2_SHARD}},
                {Logins.MANAGER_DEFAULT, new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}},
                {Logins.MANAGER_DEFAULT, new String[]{Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.SUPER_LOGIN, new String[]{Logins.CLIENT_IN_2_SHARD}},
                {Logins.SUPER_LOGIN, new String[]{Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.SUPER_LOGIN, new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}},
                {Logins.SUPPORT, new String[]{Logins.CLIENT_IN_2_SHARD}},
                {Logins.SUPPORT, new String[]{Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.SUPPORT, new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}},
                {Logins.PLACER,new String[]{ Logins.CLIENT_IN_2_SHARD}},
                {Logins.PLACER,new String[]{ Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.PLACER, new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}} ,
                {Logins.SUPER_READER, new String[]{Logins.CLIENT_IN_2_SHARD}},
                {Logins.SUPER_READER, new String[]{Logins.SUBCLIENT_IN_2_SHARD}},
                {Logins.SUPER_READER, new String[]{Logins.SERVICED_CLIENT_IN_2_SHARD}},
                {Logins.AGENCY_IN_2_SHARD,new String[]{Logins.SUB_IN_1_SHARD,Logins.SUB_IN_2_SHARD}},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest(){
        api.userSteps.clientFakeSteps().enableAPI(Logins.SUBCLIENT_IN_2_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUB_IN_1_SHARD, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUB_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SERVICED_CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initClient(){
        api.as(Logins.SUPER_LOGIN,operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5770")
    public void successGetClientInfo(){
        ClientInfo[] clientInfo = api.userSteps.clientSteps().getClientInfo(client);
        assertThat("Некорректный response",clientInfo,not(equalTo(new ClientInfo[]{})));
    }

}
