package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;

/**
 * User: pavryabov
 * Date: 10.02.14
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetClientInfoSharedAccountEnabledTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String CLIENT_LOGIN_WITH_ACCOUNT = Logins.TMONEY_CLIENT0;
    private static final String CLIENT_LOGIN_WITHOUT_ACCOUNT = Logins.TMONEY_CLIENT4;
    private static final String CLIENT_LOGIN_WITH_SELF_AND_AGENCY_ACCOUNTS = Logins.TRANSFER_CLIENT_1;
    private static final String CLIENT_LOGIN_WITH_ACCOUNT_REP = Logins.TMONEY_CLIENT0_REP;
    private static final String CLIENT_LOGIN_WITHOUT_ACCOUNT_REP = Logins.TMONEY_CLIENT4_REP;

    @Parameterized.Parameter(value = 0)
    public String agency;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public String expectedSharedAccountEnabledAgencyCall;

    @Parameterized.Parameter(value = 3)
    public String expectedSharedAccountEnabledClientCall;

    @Parameterized.Parameters(name = "Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_LOGIN_ACCOUNT_ENABLED, CLIENT_LOGIN_WITH_ACCOUNT, Value.YES, Value.NO},
                {Logins.AGENCY_LOGIN_ACCOUNT_ENABLED, CLIENT_LOGIN_WITHOUT_ACCOUNT, Value.NO, Value.NO},
                {Logins.AGENCY_LOGIN_ACCOUNT_ENABLED, CLIENT_LOGIN_WITH_ACCOUNT_REP, Value.YES, Value.NO},
                {Logins.AGENCY_LOGIN_ACCOUNT_ENABLED, CLIENT_LOGIN_WITHOUT_ACCOUNT_REP, Value.NO, Value.NO},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITH_ACCOUNT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITH_ACCOUNT_REP);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITHOUT_ACCOUNT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITHOUT_ACCOUNT_REP);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITH_SELF_AND_AGENCY_ACCOUNTS);

        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_LOGIN_ACCOUNT_ENABLED);
        api.as(Logins.AGENCY_LOGIN_ACCOUNT_ENABLED).userSteps.createAccount(CLIENT_LOGIN_WITH_ACCOUNT);
        api.userSteps.clientFakeSteps().enableAgencyWallet(ClientLogins.AGENCY_TRANSFER_1);
        api.as(ClientLogins.AGENCY_TRANSFER_1).userSteps.createAccount(CLIENT_LOGIN_WITH_SELF_AND_AGENCY_ACCOUNTS);
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(CLIENT_LOGIN_WITH_SELF_AND_AGENCY_ACCOUNTS);
        api.as(Logins.MANAGER_DEFAULT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5771")
    public void getClientInfoAgencyCall() {
        api.as(agency).userSteps.clientSteps()
                .clientShouldHasUnifiedAccount(client, equalTo(expectedSharedAccountEnabledAgencyCall));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5772")
    public void getClientInfoClientCall() {
        api.as(Logins.SUPER_LOGIN, client).userSteps.clientSteps()
                .clientShouldHasUnifiedAccount(client, equalTo(expectedSharedAccountEnabledClientCall));
    }
}
