package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.ClientInfo;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3391
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Title("Получить статус клиента: проверка работоспособности поля "
        + ClientInfoMap.STATUS_ARCH + " для клиента с активными кампаниями")
public class GetClientInfoStatusArchTest {

    private static final String MANAGER = ClientLogins.MANAGER_GEO;

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private String clientLogin;

    @Before
    @Title("Подготовка данных для теста")
    public void createCampaign() {
        api.as(MANAGER);
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createNewServicedSubClient("servicedClient", MANAGER, Currency.RUB);
        clientLogin = createNewSubclientResponse.getLogin();
        api.userSteps.balanceSteps().createPersonPh(createNewSubclientResponse.getClientID());
    }

    @Test
    @Title("Клиент с активной кампанией")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5773")
    public void clientWithActiveCampaign() {
        Long campaignId = api.userSteps.campaignStepsV5().addDefaultTextCampaign(clientLogin);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);
        int invoiceID = api.userSteps.createInvoice(campaignId.intValue(),
                MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
        api.userSteps.balanceSteps().turnOnInvoice(invoiceID);
        int accountID = api.userSteps.financeSteps().getAccountID(clientLogin);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.financeSteps().accountSumChanged(accountID));

        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        assertThat(capitalize(ClientInfoMap.STATUS_ARCH) + " равен " + Value.NO,
                clientInfo.getStatusArch(), equalTo(Value.NO));
    }

    @Test
    @Title("Клиент с кампанией-черновиком")
    @ru.yandex.qatools.allure.annotations.TestCaseId("5774")
    public void clientWithDraftCampaign() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(clientLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, clientLogin);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, clientLogin);

        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        assertThat(capitalize(ClientInfoMap.STATUS_ARCH) + " равен " + Value.NO,
                clientInfo.getStatusArch(), equalTo(Value.NO));
    }
}
