package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;

/**
 * Author pavryabov
 * Date 16.04.14
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENT)
@Tag(TagDictionary.TRUNK)
public class GetClientInfoTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    public String loginWithDot = Logins.CLIENT_DOT_LOGIN;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5775")
    public void getClientInfoWithDotInLogin() {
        ClientInfo clientInfo =
                (ClientInfo) api.as(loginWithDot).userSteps.clientSteps().getClientInfo(loginWithDot);
        assertThat(clientInfo.getLogin(), notNullValue());
    }
}
