package ru.yandex.autotests.directapi.clients.getclientinfo;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 15.01.14.
 * для логина выставляем лимит вызова GetClientInfo = 1
 * убедившись что логин находится в 1 шарде
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Stories(ApiStories.SHARDING)
public class ShardingLimitTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.DIRECT_LIMIT_MAN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void initTest(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.DIRECT_LIMIT_MAN, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientSteps().getClientInfo(Logins.DIRECT_LIMIT_MAN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5776")
    public void tryExceedLimitInAnotherShardTest(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.DIRECT_LIMIT_MAN, ShardNumbers.EXTRA_SHARD);
        api.userSteps.shouldGetErrorOn(Method.GET_CLIENT_INFO,
                new String[]{Logins.DIRECT_LIMIT_MAN},
                new AxisError(56));
    }
}
