package ru.yandex.autotests.directapi.clients.getclientslist;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 07.10.13
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
@Stories(ApiStories.SHARED_ACCOUNT)
public class GetClientInfoBigAgencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String login = "i-media";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104)
            .wsdl(APIPort_PortType.class).as(Logins.SUPER_LOGIN, login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static CreateNewSubclientResponse client;

    @BeforeClass
    public static void createClientWithAccount(){
        api.userSteps.clientFakeSteps().enableToCreateSubClients(login);
        api.userSteps.clientFakeSteps().enableAgencyWallet(login);
        client =  api.userSteps.clientSteps().createNewAgencySubClient("test", login, Currency.RUB);
        api.userSteps.campaignStepsV5().addDefaultTextCampaign(client.getLogin());
        api.userSteps.financeSteps().enableSharedAccount(client.getLogin());
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5777")
    public void getClientInfo() {
        ClientInfo[] clientInfo = api.userSteps.clientSteps().getClientsList();
        ClientInfo clientWithAccount = selectFirst(clientInfo, having(on(ClientInfo.class).getLogin().toLowerCase(),
                equalTo(client.getLogin().toLowerCase())));
        assertThat("Неправильное значение SharedAccountEnabled",
                clientWithAccount.getSharedAccountEnabled(),
                equalTo(Value.YES));


    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5778")
    public void getClientInfoNoAccount() {
        ClientInfo[] clientInfo = api.userSteps.clientSteps().getClientsList();
        ClientInfo clientWithAccount = selectFirst(clientInfo, having(on(ClientInfo.class).getLogin().toLowerCase(),
                not(equalTo(client.getLogin().toLowerCase()))));
        assertThat("Неправильное значение SharedAccountEnabled",
                clientWithAccount.getSharedAccountEnabled(),
                equalTo(Value.NO));


    }
}
