package ru.yandex.autotests.directapi.clients.getclientslist;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyClient2JSONRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.WhiteListConstraint;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.select;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by chicos on 29.05.2015.
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
@Stories(ApiStories.CURRENCY)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-41617")
@Description("Проверка значений овердрафта, возвращаемых в валюте клиента в поле OverdraftSumAvailableInCurrency")
public class GetClientListOverdraftSumInCurrencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private DarkSideSteps darkSideSteps = new DarkSideSteps();

    private static final Class clientWsdl = ru.yandex.autotests.directapi.common.api45.APIPort_PortType.class;
    private Money overdraftLimit;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String operator;

    @Parameterized.Parameter(value = 2)
    public String client;

    @Parameterized.Parameter(value = 3)
    public Currency currency;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {"Агентство клиента RUB", ClientLogins.AGENCY_RUB, ClientLogins.SUBCLIENT_RUB, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    @Before
    @Description("Подготовим данные для теста")
    public void prepareOverdraft() {
        api.as(operator).wsdl(clientWsdl);
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        overdraftLimit = Money.valueOf(MoneyCurrency.get(currency).getMinTransferAmount().floatValue(), currency);

        NotifyClient2JSONRequest request = new NotifyClient2JSONRequest().defaultParams()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withTimestamp()
                .withOverdraftLimit(overdraftLimit.floatValue())
                .withOverdraftSpent(0f)
                .withClientCurrency(currency.value());

        log.info("Вызываем метод NotifyClient2 - выставим значение овердрафта клиенту " + client);
        darkSideSteps.getBalanceClientNotifyClientJsonSteps().notifyClientNoErrors(request);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5779")
    public void overdraftInCurrencyTest() {
        ClientInfo[] infos = api.userSteps.clientSteps().getClientsList();
        List<ClientInfo> clientInfo = select(infos, having(on(ClientInfo.class).getLogin(), equalTo(client)));
        assumeThat("получили необходимого субклиента", clientInfo, hasSize(equalTo(1)));

        ClientInfoMap expectedInfo = new ClientInfoMap(api.type())
                .withOverdraftSumAvailable(null)
                .withOverdraftSumAvailableInCurrency(
                        overdraftLimit.subtractVAT().setScale(2, RoundingMode.DOWN).floatValue());

        assertThat("корректные суммы овердрафта", clientInfo.get(0), beanEquivalent(expectedInfo.getBean())
                .fields(new WhiteListConstraint().putFields(
                        ClientInfoMap.OVERDRAFT_SUM_AVAILABLE,
                        ClientInfoMap.OVERDRAFT_SUM_AVAILABLE_IN_CURRENCY)));
    }
}
