package ru.yandex.autotests.directapi.clients.getclientslist;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 10.02.14
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
public class GetClientListSharedAccountEnabledTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String agencyLogin = Logins.AGENCY_LOGIN_ACCOUNT_ENABLED;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String CLIENT_LOGIN_WITH_ACCOUNT = Logins.TMONEY_CLIENT0;
    private static final String CLIENT_LOGIN_WITHOUT_ACCOUNT = Logins.TMONEY_CLIENT4;

    @BeforeClass
    public static void createAccount() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITH_ACCOUNT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT_LOGIN_WITHOUT_ACCOUNT);
        api.userSteps.createAccount(CLIENT_LOGIN_WITH_ACCOUNT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5780")
    public void getClientsListWithAccount() {
        ClientInfo[] clientInfos = api.userSteps.clientSteps().getClientsList();
        ClientInfo clientWithAccount = selectFirst(Arrays.asList(clientInfos),
                having(on(ClientInfo.class).getLogin(),  equalTo(CLIENT_LOGIN_WITH_ACCOUNT)));
        assertThat("Неправильное значение SharedAccountEnabled",
                clientWithAccount.getSharedAccountEnabled(), equalTo(Value.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5781")
    public void getClientsListWithoutAccount() {
        ClientInfo[] clientInfos = api.userSteps.clientSteps().getClientsList();
        ClientInfo clientInfo = selectFirst(Arrays.asList(clientInfos),
                having(on(ClientInfo.class).getLogin(),  equalTo(CLIENT_LOGIN_WITHOUT_ACCOUNT)));


        assertThat("Неправильное значение SharedAccountEnabled",
                clientInfo.getSharedAccountEnabled(), equalTo(Value.NO));
    }
}
