package ru.yandex.autotests.directapi.clients.getclientslist;

import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.matchers.clients.ClientMatchers;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItemInArray;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 21.10.13
 *
 * https://jira.yandex-team.ru/browse/DIRECT-25351
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
@Stories(ApiStories.MKB_LOGINS)
@Tag(TagDictionary.TRUNK)
public class GetClientsListMKBTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());


    static String agencyLogin = "TurMasterRu";
    String mkbLogin = "dent-luxkz2013";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5783")
    public void getClientListShouldNotReturnMKB() {
        api.as(Logins.SUPER_LOGIN, agencyLogin);
        ClientInfo[] clients = api.userSteps.clientSteps().getClientsList();
        assertThat("В ответе вернулся МКБ-логин (DIRECT-25351)",
                clients,
                not(hasItemInArray(ClientMatchers.hasLogin(mkbLogin))));
    }
}
