package ru.yandex.autotests.directapi.clients.getclientslist;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
@RunWith(Parameterized.class)
public class GetClientsListShardingPositiveTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameters(name = "Operator = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_IN_2_SHARD},
                {Logins.AGENCY_YE_DEFAULT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUser(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initClient(){
        api.as(Logins.SUPER_LOGIN,operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5784")
    public void successGetClientListTest(){
        ClientInfo[] clientsInfo = api.userSteps.clientSteps().getClientsList();
        assertThat("Получили пустой список клиентов.",clientsInfo,not(equalTo(new ClientInfo[]{})));
    }

}
