package ru.yandex.autotests.directapi.clients.getclientslist;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfoRequest;
import ru.yandex.autotests.directapi.model.AuthenticationData;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_LIST)
@RunWith(Parameterized.class)
public class MethodAvailabilityTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public ApiAccessCredentials credentials;

    @Parameterized.Parameter(1)
    public int apiVersion;

    @Parameterized.Parameter(2)
    public AxisError error;

    @Parameterized.Parameters()
    public static Collection testCases() {
        return Arrays.asList(new Object[][] {
                {AuthenticationData.HAS_NO_SPECIAL_ACCESS, 4, new AxisError(509)},
                {AuthenticationData.HAS_NO_SPECIAL_ACCESS, 104, new AxisError(509)},
                {AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4LIVE, 4, new AxisError(509)},
                {AuthenticationData.HAS_ACCESS_TO_DEPRECATED_V4_AND_LIVE, 4, new AxisError(509)}
        });
    }

    @Test
    public void getClientInfoWithDotInLogin() {
        api.version(apiVersion).as(credentials.getLogin()).applicationID(credentials.getApplicationId())
                .userSteps.clientSteps().shouldGetErrorOn(Method.GET_CLIENTS_LIST, new ClientInfoRequest(), error);
    }
}
