package ru.yandex.autotests.directapi.clients.getclientunits;

import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 21.10.13
 *
 * https://jira.yandex-team.ru/browse/DIRECT-25351
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_UNITS)
@Stories(ApiStories.MKB_LOGINS)
@Tag(TagDictionary.TRUNK)
@Description(
        "[GetClientUnits] должен возвращать баллы для баяновских логинов. \n" +
        "( https://jira.yandex-team.ru/browse/DIRECT-25351 )")
public class GetClientUnitsMKBLoginsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());


    static String agencyLogin = "TurMasterRu";
    String mkbLogin = "dent-luxkz2013";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5785")
    public void getClientInfoReturnMKB() {
        api.as(Logins.SUPER_LOGIN, agencyLogin);
        ClientsUnitInfo client = api.userSteps.clientSteps().getClientUnits(mkbLogin);
        assertThat("Нет данных по МКБ-логину", client, not(nullValue()));
    }
}
