package ru.yandex.autotests.directapi.clients.getclientunits;

import org.hamcrest.Matcher;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining.hasItems;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 2/12/15.
 * https://st.yandex-team.ru/TESTIRT-4281
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_UNITS)
@Description("Получение баллов при участии представителей клиентов или агенств")
@Issue("https://st.yandex-team.ru/DIRECT-39032")
@RunWith(Parameterized.class)
public class GetClientsUnitsRepresentativeTest {

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public String[] logins;

    @Parameterized.Parameter(3)
    public Matcher expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"получение баллов от имени клиента для двух его представителей",
                        ClientLogins.CLIENT_FREE_YE_DEFAULT,
                        new String[]{
                                ClientLogins.CLIENT_FREE_YE_DEFAULT_REP,
                                ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2},
                        hasItems(
                                equalTo(ClientLogins.CLIENT_FREE_YE_DEFAULT_REP),
                                equalTo(ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2))},

                {"получение баллов от имени агенства для двух его представителей",
                        ClientLogins.AGENCY_YE_DEFAULT,
                        new String[]{
                                ClientLogins.AGENCY_YE_DEFAULT_REP,
                                ClientLogins.AGENCY_YE_DEFAULT_REP_2},
                        hasItems(
                                equalTo(ClientLogins.AGENCY_YE_DEFAULT_REP),
                                equalTo(ClientLogins.AGENCY_YE_DEFAULT_REP_2))},

                {"получение баллов от имени представителя клиента без указания логинов",
                        ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2,
                        null,
                        hasItems(
                                equalTo(ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2))},

                {"получение баллов от имени представителя клиента с указанием своего логина",
                        ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2,
                        new String[]{
                                ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2},
                        hasItems(
                                equalTo(ClientLogins.CLIENT_FREE_YE_DEFAULT_REP_2))},

                {"получение баллов от имени представителя агенства без указания логинов",
                        ClientLogins.AGENCY_YE_DEFAULT_REP,
                        null,
                        hasItems(
                                equalTo(ClientLogins.AGENCY_YE_DEFAULT_REP))},

                {"получение баллов от имени представителя агенства с указанием своего логина",
                        ClientLogins.AGENCY_YE_DEFAULT_REP,
                        new String[]{
                                ClientLogins.AGENCY_YE_DEFAULT_REP},
                        hasItems(
                                equalTo(ClientLogins.AGENCY_YE_DEFAULT_REP))},
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5786")
    public void getClientsUnits() {
        api.as(login);
        ClientsUnitInfo[] clientUnitsInfos = api.userSteps.clientSteps().getClientsUnits(logins);
        String[] resultLogins = extract(clientUnitsInfos, on(ClientsUnitInfo.class).getLogin()).toArray(new String[0]);
        assertThat("в ответе соддержатся верные логины", resultLogins, expectedResult);
    }
}
