package ru.yandex.autotests.directapi.clients.getclientunits;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by ginger on 13.01.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-27463
 */
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_UNITS)
@RunWith(Parameterized.class)
public class GetClientsUnitsShardingNegativeTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_IN_2_SHARD, Logins.SUBCLIENT_IN_2_SHARD},
                {Logins.MANAGER_DEFAULT, Logins.CLIENT_IN_2_SHARD},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest(){
        api.userSteps.clientFakeSteps().enableAPI(Logins.SUBCLIENT_IN_2_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.CLIENT_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_IN_2_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initClient(){
        api.as(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5787")
    public void tryGetClientUnitsShouldBeError(){
        api.userSteps.shouldGetErrorOn(Method.GET_CLIENTS_UNITS,
                new String[]{client},
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
