package ru.yandex.autotests.directapi.clients.getclientunits;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by ginger on 21.01.14.
 */

//https://jira.yandex-team.ru/browse/DIRECT-27463
@Aqua.Test
@Features(ClientFeatures.GET_CLIENTS_UNITS)
public class TheSameUnitsInAnotherShardTest {
    protected Logger log = LogManager.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5789")
    public void successReshardUnitsTest(){
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.DIRECT_LIMIT_MAN_1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().setAPIUnits(Logins.DIRECT_LIMIT_MAN_1,6666);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.DIRECT_LIMIT_MAN_1, ShardNumbers.EXTRA_SHARD);
        ClientsUnitInfo clientInfo = api.userSteps.clientSteps().getClientUnits(Logins.DIRECT_LIMIT_MAN_1);
        assertThat("Неверный ответ",clientInfo.getUnitsRest(),equalTo(6666));
    }
}
