package ru.yandex.autotests.directapi.clients.pingapi;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ApiAccessCredentials;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.clients.ClientFeatures;
import ru.yandex.autotests.directapi.clients.ClientLogins;
import ru.yandex.autotests.directapi.model.AuthenticationData;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-5471
 */
@Aqua.Test
@Features(ClientFeatures.PING_API)
@Issue("https://st.yandex-team.ru/DIRECT-41831")
@Description("Проверка доступа к API клиента с вечным токеном")
public class PersistentTokenTest {
    private static ApiAccessCredentials credentials = AuthenticationData.PERSISTENT_TOKEN_CREDENTIALS;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(credentials.getLogin());

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static MongoUser user;

    @BeforeClass
    public static void init() {
        user = MongoUser.get(credentials.getLogin());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5795")
    public void checkAccessToAPIWithPersistentToken() {
        // Persistent token хранится в поле sandboxToken
        api.as(credentials.getLogin()).token("").persistentToken(user.getSandboxToken());
        assertThat("PingAPI вернул правильный ответ",
                api.userSteps.pingAPISteps().pingAPI(), equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5796")
    public void checkAccessToAPIWithAccessTokenForClientWithPersistentToken() {
        api.as(credentials.getLogin());
        assertThat("PingAPI вернул правильный ответ",
                api.userSteps.pingAPISteps().pingAPI(), equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5797")
    public void checkAccessToAPIWithPersistentTokenAndAccessToken() {
        //DIRECT-41968
        // Persistent token хранится в поле sandboxToken
        api.as(credentials.getLogin()).persistentToken(user.getSandboxToken());
        api.userSteps.shouldGetErrorOn(Method.PING_API, (Object) null,
                new AxisError(53, AxisErrorDetails.INVALID_USE_PERSISTENT_TOKEN));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5798")
    public void checkAccessOfClientWithoutPersistentToken() {
        // Persistent token хранится в поле sandboxToken
        api.as(ClientLogins.CLIENT_FREE_YE_DEFAULT).token("").persistentToken(user.getSandboxToken());
        api.userSteps.shouldGetErrorOn(Method.PING_API, (Object) null, new AxisError(53));
    }
}
